﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;

namespace KMAP
{
    public partial class Form1 : Form
    {

        public Form1()
        {
            InitializeComponent();
        }


        // Variables that my combobox-replacer system uses to determine which combobox is having its text replaced. Defaulted to 0.
        public int bodymassbox = 0;
        public int bodyradiusbox = 0;


        #region KMAP Note Box - Pseudo-Tooltip Control
        private void KMAPNotes_richTextBox_Enter(object sender, EventArgs e)
        {
            if (KMAPNotes_richTextBox.Text == "A notepad for use between tabs.")
            {
                KMAPNotes_richTextBox.Text = "";
            }
        }

        private void KMAPNotes_richTextBox_Leave(object sender, EventArgs e)
        {
            if (KMAPNotes_richTextBox.Text == "")
            {
                KMAPNotes_richTextBox.Text = "A notepad for use between tabs.";
            }
        }
        #endregion


        #region OnStart Stuff
        // When the form loads, input the math in the various richtextboxes.
        private void Form1_Load(object sender, EventArgs e)
        {

        }

        // TextBox input validation (Don't allow letters to be inputted into the text boxes).
        // The only thing that can bypass it is the user using ctrl+v to paste something. Fix this later with a "TextChanged" event.
        private void TextBox_NumericOnly_KeyPress(object sender, KeyPressEventArgs e)
        {
            //if input is not a control char, digit, or '.', do nothing.
            if (!char.IsControl(e.KeyChar) && !char.IsDigit(e.KeyChar) && (e.KeyChar != '.') && (e.KeyChar != ','))
            {
                e.Handled = true;
            }

            //only allow one decimal point
            //user inputs '.' and there is already one.
            if ((e.KeyChar == '.') && ((sender as TextBox).Text.IndexOf('.') > -1))
            {
                e.Handled = true;
            }
        }
        #endregion


        #region Functions
        // Zero or null input error warning.
        async private void InputErrorWarning()
        {
            await Task.Delay(1);
            MessageBox.Show("Input cannot be empty or zero.", "INPUT ERROR");
        }

        // Body Radius ComboBox Text Replacer Function.
        async private void BodyRadiusComboBoxTextReplacer()
        {
            await Task.Delay(1);

            if (bodyradiusbox == 1)
            {
                #region Switch-Space
                string PlanetName = SemMajAxTab_InputBodyRadius_ComboBox.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "261,600,000";
                        break;

                    case "Moho":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "250,000";
                        break;

                    case "Eve":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "700,000";
                        break;

                    case "Gilly":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "13,000";
                        break;

                    case "Kerbin":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "600,000";
                        break;

                    case "Mun":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "200,000";
                        break;

                    case "Minmus":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "60,000";
                        break;

                    case "Duna":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "320,000";
                        break;

                    case "Ike":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "130,000";
                        break;

                    case "Dres":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "138,000";
                        break;

                    case "Jool":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "6,000,000";
                        break;

                    case "Laythe":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "500,000";
                        break;

                    case "Vall":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "300,000";
                        break;

                    case "Tylo":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "600,000";
                        break;

                    case "Bop":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "65,000";
                        break;

                    case "Pol":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "44,000";
                        break;

                    case "Eeloo":
                        SemMajAxTab_InputBodyRadius_ComboBox.Text = "210,000";
                        break;
                }
                #endregion
            }

            if (bodyradiusbox == 2)
            {
                #region Switch-Space
                string PlanetName = OPTab_InputBodyRadius_ComboBox.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        OPTab_InputBodyRadius_ComboBox.Text = "261,600,000";
                        break;

                    case "Moho":
                        OPTab_InputBodyRadius_ComboBox.Text = "250,000";
                        break;

                    case "Eve":
                        OPTab_InputBodyRadius_ComboBox.Text = "700,000";
                        break;

                    case "Gilly":
                        OPTab_InputBodyRadius_ComboBox.Text = "13,000";
                        break;

                    case "Kerbin":
                        OPTab_InputBodyRadius_ComboBox.Text = "600,000";
                        break;

                    case "Mun":
                        OPTab_InputBodyRadius_ComboBox.Text = "200,000";
                        break;

                    case "Minmus":
                        OPTab_InputBodyRadius_ComboBox.Text = "60,000";
                        break;

                    case "Duna":
                        OPTab_InputBodyRadius_ComboBox.Text = "320,000";
                        break;

                    case "Ike":
                        OPTab_InputBodyRadius_ComboBox.Text = "130,000";
                        break;

                    case "Dres":
                        OPTab_InputBodyRadius_ComboBox.Text = "138,000";
                        break;

                    case "Jool":
                        OPTab_InputBodyRadius_ComboBox.Text = "6,000,000";
                        break;

                    case "Laythe":
                        OPTab_InputBodyRadius_ComboBox.Text = "500,000";
                        break;

                    case "Vall":
                        OPTab_InputBodyRadius_ComboBox.Text = "300,000";
                        break;

                    case "Tylo":
                        OPTab_InputBodyRadius_ComboBox.Text = "600,000";
                        break;

                    case "Bop":
                        OPTab_InputBodyRadius_ComboBox.Text = "65,000";
                        break;

                    case "Pol":
                        OPTab_InputBodyRadius_ComboBox.Text = "44,000";
                        break;

                    case "Eeloo":
                        OPTab_InputBodyRadius_ComboBox.Text = "210,000";
                        break;
                }
                #endregion
            }

            if (bodyradiusbox == 3)
            {
                #region Switch-Space
                string PlanetName = HohTab_InputBodyRadius_ComboBox1.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        HohTab_InputBodyRadius_ComboBox1.Text = "261,600,000";
                        break;

                    case "Moho":
                        HohTab_InputBodyRadius_ComboBox1.Text = "250,000";
                        break;

                    case "Eve":
                        HohTab_InputBodyRadius_ComboBox1.Text = "700,000";
                        break;

                    case "Gilly":
                        HohTab_InputBodyRadius_ComboBox1.Text = "13,000";
                        break;

                    case "Kerbin":
                        HohTab_InputBodyRadius_ComboBox1.Text = "600,000";
                        break;

                    case "Mun":
                        HohTab_InputBodyRadius_ComboBox1.Text = "200,000";
                        break;

                    case "Minmus":
                        HohTab_InputBodyRadius_ComboBox1.Text = "60,000";
                        break;

                    case "Duna":
                        HohTab_InputBodyRadius_ComboBox1.Text = "320,000";
                        break;

                    case "Ike":
                        HohTab_InputBodyRadius_ComboBox1.Text = "130,000";
                        break;

                    case "Dres":
                        HohTab_InputBodyRadius_ComboBox1.Text = "138,000";
                        break;

                    case "Jool":
                        HohTab_InputBodyRadius_ComboBox1.Text = "6,000,000";
                        break;

                    case "Laythe":
                        HohTab_InputBodyRadius_ComboBox1.Text = "500,000";
                        break;

                    case "Vall":
                        HohTab_InputBodyRadius_ComboBox1.Text = "300,000";
                        break;

                    case "Tylo":
                        HohTab_InputBodyRadius_ComboBox1.Text = "600,000";
                        break;

                    case "Bop":
                        HohTab_InputBodyRadius_ComboBox1.Text = "65,000";
                        break;

                    case "Pol":
                        HohTab_InputBodyRadius_ComboBox1.Text = "44,000";
                        break;

                    case "Eeloo":
                        HohTab_InputBodyRadius_ComboBox1.Text = "210,000";
                        break;
                }
                #endregion
            }

            if (bodyradiusbox == 4)
            {
                #region Switch-Space
                string PlanetName = HohTab_InputBodyRadius_ComboBox4.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        HohTab_InputBodyRadius_ComboBox4.Text = "261,600,000";
                        break;

                    case "Moho":
                        HohTab_InputBodyRadius_ComboBox4.Text = "250,000";
                        break;

                    case "Eve":
                        HohTab_InputBodyRadius_ComboBox4.Text = "700,000";
                        break;

                    case "Gilly":
                        HohTab_InputBodyRadius_ComboBox4.Text = "13,000";
                        break;

                    case "Kerbin":
                        HohTab_InputBodyRadius_ComboBox4.Text = "600,000";
                        break;

                    case "Mun":
                        HohTab_InputBodyRadius_ComboBox4.Text = "200,000";
                        break;

                    case "Minmus":
                        HohTab_InputBodyRadius_ComboBox4.Text = "60,000";
                        break;

                    case "Duna":
                        HohTab_InputBodyRadius_ComboBox4.Text = "320,000";
                        break;

                    case "Ike":
                        HohTab_InputBodyRadius_ComboBox4.Text = "130,000";
                        break;

                    case "Dres":
                        HohTab_InputBodyRadius_ComboBox4.Text = "138,000";
                        break;

                    case "Jool":
                        HohTab_InputBodyRadius_ComboBox4.Text = "6,000,000";
                        break;

                    case "Laythe":
                        HohTab_InputBodyRadius_ComboBox4.Text = "500,000";
                        break;

                    case "Vall":
                        HohTab_InputBodyRadius_ComboBox4.Text = "300,000";
                        break;

                    case "Tylo":
                        HohTab_InputBodyRadius_ComboBox4.Text = "600,000";
                        break;

                    case "Bop":
                        HohTab_InputBodyRadius_ComboBox4.Text = "65,000";
                        break;

                    case "Pol":
                        HohTab_InputBodyRadius_ComboBox4.Text = "44,000";
                        break;

                    case "Eeloo":
                        HohTab_InputBodyRadius_ComboBox4.Text = "210,000";
                        break;
                }
                #endregion
            }
            
            #region Planet Radii
            // Kerbol - 261,600,000 m
            // Moho - 250,000 m
            // Eve - 700,000 m
            // Gilly - 13,000 m
            // Kerbin - 600,000 m
            // Mun - 200,000 m
            // Minmus - 60,000 m
            // Duna - 320,000 m
            // Ike - 130,000 m
            // Dres - 138,000 m
            // Jool - 6,000,000 m
            // Laythe - 500,000 m
            // Vall - 300,000 m
            // Tylo - 600,000 m
            // Bop - 65,000 m
            // Pol - 44,000 m
            // Eeloo - 210,000 m
            #endregion
        }
        
        // Body Mass ComboBox Text Replacer Function.
        async private void BodyMassComboBoxTextReplacer()
        {
            await Task.Delay(1);

            if (bodymassbox == 1)
            {
                #region Switch-Space
                string PlanetName = OPTab_InputBodyMass_ComboBox.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        OPTab_InputBodyMass_ComboBox.Text = "1.7565670e+28";
                        break;

                    case "Moho":
                        OPTab_InputBodyMass_ComboBox.Text = "2.5263617e+21";
                        break;

                    case "Eve":
                        OPTab_InputBodyMass_ComboBox.Text = "1.2244127e+23";
                        break;

                    case "Gilly":
                        OPTab_InputBodyMass_ComboBox.Text = "1.2420512e+17";
                        break;

                    case "Kerbin":
                        OPTab_InputBodyMass_ComboBox.Text = "5.2915793e+22";
                        break;

                    case "Mun":
                        OPTab_InputBodyMass_ComboBox.Text = "9.7600236e+20";
                        break;

                    case "Minmus":
                        OPTab_InputBodyMass_ComboBox.Text = "2.6457897e+19";
                        break;

                    case "Duna":
                        OPTab_InputBodyMass_ComboBox.Text = "4.5154812e+21";
                        break;

                    case "Ike":
                        OPTab_InputBodyMass_ComboBox.Text = "2.7821949e+20";
                        break;

                    case "Dres":
                        OPTab_InputBodyMass_ComboBox.Text = "3.2191322e+20";
                        break;

                    case "Jool":
                        OPTab_InputBodyMass_ComboBox.Text = "4.2332635e+24";
                        break;

                    case "Laythe":
                        OPTab_InputBodyMass_ComboBox.Text = "2.9397663e+22";
                        break;

                    case "Vall":
                        OPTab_InputBodyMass_ComboBox.Text = "3.1088028e+21";
                        break;

                    case "Tylo":
                        OPTab_InputBodyMass_ComboBox.Text = "4.2332635e+22";
                        break;

                    case "Bop":
                        OPTab_InputBodyMass_ComboBox.Text = "3.7261536e+19";
                        break;

                    case "Pol":
                        OPTab_InputBodyMass_ComboBox.Text = "1.0813636e+19";
                        break;

                    case "Eeloo":
                        OPTab_InputBodyMass_ComboBox.Text = "1.1149358e+21";
                        break;
                }
                #endregion
            }
           
            if (bodymassbox == 2)
            {
                #region Switch-Space
                string PlanetName = OPTab_InputBodyMass2_ComboBox.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        OPTab_InputBodyMass2_ComboBox.Text = "1.7565670e+28";
                        break;

                    case "Moho":
                        OPTab_InputBodyMass2_ComboBox.Text = "2.5263617e+21";
                        break;

                    case "Eve":
                        OPTab_InputBodyMass2_ComboBox.Text = "1.2244127e+23";
                        break;

                    case "Gilly":
                        OPTab_InputBodyMass2_ComboBox.Text = "1.2420512e+17";
                        break;

                    case "Kerbin":
                        OPTab_InputBodyMass2_ComboBox.Text = "5.2915793e+22";
                        break;

                    case "Mun":
                        OPTab_InputBodyMass2_ComboBox.Text = "9.7600236e+20";
                        break;

                    case "Minmus":
                        OPTab_InputBodyMass2_ComboBox.Text = "2.6457897e+19";
                        break;

                    case "Duna":
                        OPTab_InputBodyMass2_ComboBox.Text = "4.5154812e+21";
                        break;

                    case "Ike":
                        OPTab_InputBodyMass2_ComboBox.Text = "2.7821949e+20";
                        break;

                    case "Dres":
                        OPTab_InputBodyMass2_ComboBox.Text = "3.2191322e+20";
                        break;

                    case "Jool":
                        OPTab_InputBodyMass2_ComboBox.Text = "4.2332635e+24";
                        break;

                    case "Laythe":
                        OPTab_InputBodyMass2_ComboBox.Text = "2.9397663e+22";
                        break;

                    case "Vall":
                        OPTab_InputBodyMass2_ComboBox.Text = "3.1088028e+21";
                        break;

                    case "Tylo":
                        OPTab_InputBodyMass2_ComboBox.Text = "4.2332635e+22";
                        break;

                    case "Bop":
                        OPTab_InputBodyMass2_ComboBox.Text = "3.7261536e+19";
                        break;

                    case "Pol":
                        OPTab_InputBodyMass2_ComboBox.Text = "1.0813636e+19";
                        break;

                    case "Eeloo":
                        OPTab_InputBodyMass2_ComboBox.Text = "1.1149358e+21";
                        break;
                }
                #endregion
            }

            if (bodymassbox == 3)
            {
                #region Switch-Space
                string PlanetName = HohTab_InputBodyMass_ComboBox1.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        HohTab_InputBodyMass_ComboBox1.Text = "1.7565670e+28";
                        break;

                    case "Moho":
                        HohTab_InputBodyMass_ComboBox1.Text = "2.5263617e+21";
                        break;

                    case "Eve":
                        HohTab_InputBodyMass_ComboBox1.Text = "1.2244127e+23";
                        break;

                    case "Gilly":
                        HohTab_InputBodyMass_ComboBox1.Text = "1.2420512e+17";
                        break;

                    case "Kerbin":
                        HohTab_InputBodyMass_ComboBox1.Text = "5.2915793e+22";
                        break;

                    case "Mun":
                        HohTab_InputBodyMass_ComboBox1.Text = "9.7600236e+20";
                        break;

                    case "Minmus":
                        HohTab_InputBodyMass_ComboBox1.Text = "2.6457897e+19";
                        break;

                    case "Duna":
                        HohTab_InputBodyMass_ComboBox1.Text = "4.5154812e+21";
                        break;

                    case "Ike":
                        HohTab_InputBodyMass_ComboBox1.Text = "2.7821949e+20";
                        break;

                    case "Dres":
                        HohTab_InputBodyMass_ComboBox1.Text = "3.2191322e+20";
                        break;

                    case "Jool":
                        HohTab_InputBodyMass_ComboBox1.Text = "4.2332635e+24";
                        break;

                    case "Laythe":
                        HohTab_InputBodyMass_ComboBox1.Text = "2.9397663e+22";
                        break;

                    case "Vall":
                        HohTab_InputBodyMass_ComboBox1.Text = "3.1088028e+21";
                        break;

                    case "Tylo":
                        HohTab_InputBodyMass_ComboBox1.Text = "4.2332635e+22";
                        break;

                    case "Bop":
                        HohTab_InputBodyMass_ComboBox1.Text = "3.7261536e+19";
                        break;

                    case "Pol":
                        HohTab_InputBodyMass_ComboBox1.Text = "1.0813636e+19";
                        break;

                    case "Eeloo":
                        HohTab_InputBodyMass_ComboBox1.Text = "1.1149358e+21";
                        break;
                }
                #endregion
            }

            if (bodymassbox == 4)
            {
                #region Switch-Space
                string PlanetName = HohTab_InputBodyMass_ComboBox2.Text;
                switch (PlanetName)
                {
                    case "Kerbol":
                        HohTab_InputBodyMass_ComboBox2.Text = "1.7565670e+28";
                        break;

                    case "Moho":
                        HohTab_InputBodyMass_ComboBox2.Text = "2.5263617e+21";
                        break;

                    case "Eve":
                        HohTab_InputBodyMass_ComboBox2.Text = "1.2244127e+23";
                        break;

                    case "Gilly":
                        HohTab_InputBodyMass_ComboBox2.Text = "1.2420512e+17";
                        break;

                    case "Kerbin":
                        HohTab_InputBodyMass_ComboBox2.Text = "5.2915793e+22";
                        break;

                    case "Mun":
                        HohTab_InputBodyMass_ComboBox2.Text = "9.7600236e+20";
                        break;

                    case "Minmus":
                        HohTab_InputBodyMass_ComboBox2.Text = "2.6457897e+19";
                        break;

                    case "Duna":
                        HohTab_InputBodyMass_ComboBox2.Text = "4.5154812e+21";
                        break;

                    case "Ike":
                        HohTab_InputBodyMass_ComboBox2.Text = "2.7821949e+20";
                        break;

                    case "Dres":
                        HohTab_InputBodyMass_ComboBox2.Text = "3.2191322e+20";
                        break;

                    case "Jool":
                        HohTab_InputBodyMass_ComboBox2.Text = "4.2332635e+24";
                        break;

                    case "Laythe":
                        HohTab_InputBodyMass_ComboBox2.Text = "2.9397663e+22";
                        break;

                    case "Vall":
                        HohTab_InputBodyMass_ComboBox2.Text = "3.1088028e+21";
                        break;

                    case "Tylo":
                        HohTab_InputBodyMass_ComboBox2.Text = "4.2332635e+22";
                        break;

                    case "Bop":
                        HohTab_InputBodyMass_ComboBox2.Text = "3.7261536e+19";
                        break;

                    case "Pol":
                        HohTab_InputBodyMass_ComboBox2.Text = "1.0813636e+19";
                        break;

                    case "Eeloo":
                        HohTab_InputBodyMass_ComboBox2.Text = "1.1149358e+21";
                        break;
                }
                #endregion
            }
            
            #region Planet Masses
            // Kerbol - 1.7565670e+28 kg
            // Moho - 2.5263617e+21 kg
            // Eve - 1.2244127e+23 kg
            // Gilly - 1.2420512e+17 kg
            // Kerbin - 5.2915793e+22 kg
            // Mun - 9.7600236e+20 kg
            // Minmus - 2.6457897e+19 kg
            // Duna - 4.5154812e+21 kg
            // Ike - 2.7821949e+20 kg
            // Dres - 3.2191322e+20 kg
            // Jool - 4.2332635e+24 kg
            // Laythe - 2.9397663e+22 kg
            // Vall - 3.1088028e+21 kg
            // Tylo - 4.2332635e+22 kg
            // Bop - 3.7261536e+19 kg
            // Pol - 1.0813636e+19 kg
            // Eeloo - 1.1149358e+21 kg
            #endregion
        }
        #endregion


        #region Thrust to Weight Ratio Section
        // When I change the inputs for Thrust or Mass, then clear all other text boxes.
        private void TWRAccelerationInputsTextBox_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                TWRTab_OutputAccel_TextBox.Text = "0";
                TWRTab_InputAccel_TextBox.Text = "0";
                TWRTab_OutputTWR_TextBox.Text = "0";
            }
        }

        // When I change the input for acceleration or gravity, then clear the TWR output text box.
        private void TWRInputsTextBox_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                TWRTab_OutputTWR_TextBox.Text = "0";
            }
        }

        // Clicking the TWR-acceleration Calculate button.
        private void button1_Click_1(object sender, EventArgs e)
        {
            // Check if any of these values are null or zero.
            if (String.IsNullOrEmpty(TWRTab_InputThrust_TextBox.Text) || double.Parse(TWRTab_InputThrust_TextBox.Text) == 0 || String.IsNullOrEmpty(TWRTab_InputMass_TextBox.Text) || double.Parse(TWRTab_InputMass_TextBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            //Set the thrust and mass inputs to numbers I can use, and then calculate that out as the output for the TWR.
            double thrustinput = double.Parse(TWRTab_InputThrust_TextBox.Text);
            double massinput = double.Parse(TWRTab_InputMass_TextBox.Text);
            TWRTab_OutputAccel_TextBox.Text = (thrustinput / massinput).ToString();

            //Let's set the input acceleration textbox as well.
            if (Properties.Settings.Default.SettingsCheckbox1 == true)
            {
                TWRTab_InputAccel_TextBox.Text = TWRTab_OutputAccel_TextBox.Text;
            } 
        }

        // Clicking the TWR-TWR calculate button.
        private void TWRCalculate_Click(object sender, EventArgs e)
        {
            // Check if any of these values are null or zero.
            if (String.IsNullOrEmpty(TWRTab_InputAccel_TextBox.Text) || double.Parse(TWRTab_InputAccel_TextBox.Text) == 0 || String.IsNullOrEmpty(TWRTab_InputGrav_TextBox.Text) || double.Parse(TWRTab_InputGrav_TextBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            double gravityinput = double.Parse(TWRTab_InputGrav_TextBox.Text);
            double accelerationinput = double.Parse(TWRTab_OutputAccel_TextBox.Text);
            TWRTab_OutputTWR_TextBox.Text = (accelerationinput / gravityinput).ToString();
        }
        #endregion


        #region ISP Section
        // Clicking the "Add" button for the listView in the Isp tab.
        private void Isp_addButton1_Click(object sender, EventArgs e)
        {
            // Check if any of these values are null or zero.
            if (String.IsNullOrEmpty(IspTab_InputIsp_TextBox.Text) || double.Parse(IspTab_InputIsp_TextBox.Text) == 0 || String.IsNullOrEmpty(IspTab_InputThrust_TextBox.Text) || double.Parse(IspTab_InputThrust_TextBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            // Grab the variables from the input method.
            double thrustinput = double.Parse(IspTab_InputThrust_TextBox.Text);
            double ispinput = double.Parse(IspTab_InputIsp_TextBox.Text);

            // Check if any of these values are 0.
            if (thrustinput == 0 || ispinput == 0)
            {
                MessageBox.Show("Input cannot be zero.", "INPUT ERROR");
                return;
            }

            // We create a new ListViewItem in the memory. essentially this is a new row in the listView
            ListViewItem itemToAdd = new ListViewItem();
            // This '.Text' is what we see in the first column of the listview.
            itemToAdd.Text = (IspTab_IspCalculator_listView.Items.Count + 1).ToString();

            // This subitem is what we see in the second column. as we continue adding subitems, each column gets populated.
            itemToAdd.SubItems.Add(thrustinput.ToString());
            itemToAdd.SubItems.Add(ispinput.ToString());

            // Finally, add the item we created to the listview.
            IspTab_IspCalculator_listView.Items.Add(itemToAdd);

            // And reset the input box entries to 0.
            IspTab_InputThrust_TextBox.Text = "0";
            IspTab_InputIsp_TextBox.Text = "0";

            // And also reset the total Isp to 0.
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                IspTab_OutputIsp_TextBox.Text = "0";
            }
        }

        // Clicking the "Remove" button for the listView in the Isp tab.
        private void Isp_addButton2_Click(object sender, EventArgs e)
        {
            // We get the number of items in the ListView.
            int count = IspTab_IspCalculator_listView.Items.Count;

            // If there isn't at least one item, then do nothing.
            if (count < 1)
            {
                return;
            }   // At this point we know the ListView has at least one item.

            // If we have nothing selected, then just delete the last one.
            if (IspTab_IspCalculator_listView.SelectedItems.Count < 1)
            {
                IspTab_IspCalculator_listView.Items.RemoveAt(count - 1);
            }
            else // We didn't have nothing selected. So we have something selected.
            {
                // Temporarily saving the selected items index
                int selectedItem = IspTab_IspCalculator_listView.FocusedItem.Index;

                // Remove that item
                IspTab_IspCalculator_listView.Items.RemoveAt(selectedItem);

                // Updating the indices of all the items below the one we deleted.
                for (int i = selectedItem; i < count - 1; i++)
                {
                    IspTab_IspCalculator_listView.Items[i].Text = (i + 1).ToString();
                }
            }

            // And also reset the total Isp to 0.

            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
            IspTab_OutputIsp_TextBox.Text = "0";
            }
        }

        // Calculating the Isp
        // you know what += does? i += 1 is the same as i = i + 1
        private void IspTab_IspCalculator_CalculateButton_Click(object sender, EventArgs e)
        {
            // Default the variables to 0.
            double totalThrust = 0;
            double sumOfThrustDividedByIsp = 0;

            foreach (ListViewItem engine in IspTab_IspCalculator_listView.Items)
            {
                double thrust = double.Parse(engine.SubItems[1].Text);
                double isp = double.Parse(engine.SubItems[2].Text);

                totalThrust += thrust;
                sumOfThrustDividedByIsp += (thrust / isp);
            }
            IspTab_OutputIsp_TextBox.Text = (totalThrust / sumOfThrustDividedByIsp).ToString();
        }
        #endregion
        

        #region Delta V Section
        // When I change the inputs for Delta V, clear the output.
        private void DVTab_DVInputs_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                DVTab_OutputDV_TextBox.Text = "0";
            }
        }

        // Clicking the Delta V calculate button.
        private void DeltaVCalculate_Button_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(DVTab_InputIsp_TextBox.Text) || double.Parse(DVTab_InputIsp_TextBox.Text) == 0
                ||
                String.IsNullOrEmpty(DVTab_InputGravity_TextBox.Text) || double.Parse(DVTab_InputGravity_TextBox.Text) == 0
                ||
                String.IsNullOrEmpty(DVTab_InputTotalMass_TextBox.Text) || double.Parse(DVTab_InputTotalMass_TextBox.Text) == 0
                ||
                String.IsNullOrEmpty(DVTab_InputDryMass_TextBox.Text) || double.Parse(DVTab_InputDryMass_TextBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            double ispinput = double.Parse(DVTab_InputIsp_TextBox.Text);
            double gravityinput = double.Parse(DVTab_InputGravity_TextBox.Text);
            double totalmassinput = double.Parse(DVTab_InputTotalMass_TextBox.Text);
            double drymassinput = double.Parse(DVTab_InputDryMass_TextBox.Text);

            DVTab_OutputDV_TextBox.Text = (ispinput * gravityinput * Math.Log(totalmassinput / drymassinput)).ToString();

            if (Properties.Settings.Default.SettingsCheckbox1 == true)
            {
                DVTab_InputDV_TextBox.Text = DVTab_OutputDV_TextBox.Text;
            }
        }

        // Clicking the Total Delta V add button.
        private void DVTab_TotalDVCalculator_addButton_Click(object sender, EventArgs e)
        {
            // Check if any of these values are null or zero.
            if (String.IsNullOrEmpty(DVTab_InputDV_TextBox.Text) || double.Parse(DVTab_InputDV_TextBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            // Grab the variables from the input method.
            double dvinput = double.Parse(DVTab_InputDV_TextBox.Text);

            // We create a new ListViewItem in the memory. essentially this is a new row in the listView
            ListViewItem itemToAdd = new ListViewItem();
            // This '.Text' is what we see in the first column of the listview.
            itemToAdd.Text = (DVTab_TotalDVCalc_listView.Items.Count + 1).ToString();

            // This subitem is what we see in the second column. as we continue adding subitems, each column gets populated.
            itemToAdd.SubItems.Add(dvinput.ToString());

            // Finally, add the item we created to the listview.
            DVTab_TotalDVCalc_listView.Items.Add(itemToAdd);

            //And reset the input box entries to 0.
            DVTab_InputDV_TextBox.Text = "0";

            //And also reset the total DV to 0.
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                DVTab_OutputTotalDV_TextBox.Text = "0";
            }
            
        }

        // Clicking the Total Delta V calculator remove button.
        private void DVTab_TotalDVCalculator_removeButton_Click(object sender, EventArgs e)
        {
            // We get the number of items in the ListView.
            int count = DVTab_TotalDVCalc_listView.Items.Count;

            // If there isn't at least one item, then do nothing.
            if (count < 1)
            {
                return;
            }   // At this point we know the ListView has at least one item.

            // If we have nothing selected, then just delete the last one.
            if (DVTab_TotalDVCalc_listView.SelectedItems.Count < 1)
            {
                DVTab_TotalDVCalc_listView.Items.RemoveAt(count - 1);
            }
            else // We didn't have nothing selected. So we have something selected.
            {
                // Temporarily saving the selected items index
                int selectedItem = DVTab_TotalDVCalc_listView.FocusedItem.Index;

                // Remove that item
                DVTab_TotalDVCalc_listView.Items.RemoveAt(selectedItem);

                // Updating the indices of all the items below the one we deleted.
                for (int i = selectedItem; i < count - 1; i++)
                {
                    DVTab_TotalDVCalc_listView.Items[i].Text = (i + 1).ToString();
                }
            }

            //And also reset the total Isp to 0.
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                DVTab_OutputTotalDV_TextBox.Text = "0";
            }
        }

        // Clicking the Total Delta V calculate button.
        private void DVTab_TotalDVCalculator_CalculateButton_Click(object sender, EventArgs e)
        {
            // Default the variables to 0.
            double totalDV = 0;

            foreach (ListViewItem stage in DVTab_TotalDVCalc_listView.Items)
            {
                double DV = double.Parse(stage.SubItems[1].Text);

                totalDV += DV;
            }
            DVTab_OutputTotalDV_TextBox.Text = (totalDV).ToString();
        }
        #endregion


        #region Semi-Major Axis Section
        // When the inputs for the Semi-Major Axis are changed, clear the Semi-Major Axis output textbox.
        private void SemMajAxInputs_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                SemMajAxTab_OutputSemMajAx_TextBox.Text = "0";
            }
        }

        // Body Radius ComboBox text replaced when you click an option in the dropdown.
        private void SemMajAxTab_InputBodyRadius_ComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodyradiusbox = 1;
            BodyRadiusComboBoxTextReplacer();
        }

        // Clicking the Semi-Major Axis calculate button.
        private void SemMajAxTab_SemMajAxCalculator_CalculateButton_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(SemMajAxTab_InputApo_TextBox.Text) || double.Parse(SemMajAxTab_InputApo_TextBox.Text) == 0
                ||
                String.IsNullOrEmpty(SemMajAxTab_InputPeri_TextBox.Text) || double.Parse(SemMajAxTab_InputPeri_TextBox.Text) == 0
                ||
                String.IsNullOrEmpty(SemMajAxTab_InputBodyRadius_ComboBox.Text) || double.Parse(SemMajAxTab_InputBodyRadius_ComboBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            double apoapsisinput = double.Parse(SemMajAxTab_InputApo_TextBox.Text);
            double periapsisinput = double.Parse(SemMajAxTab_InputPeri_TextBox.Text);
            double bodyradiusinput = double.Parse(SemMajAxTab_InputBodyRadius_ComboBox.Text);

            SemMajAxTab_OutputSemMajAx_TextBox.Text = ((apoapsisinput + periapsisinput + (2 * bodyradiusinput)) / 2).ToString();
        }
        #endregion


        #region Orbital Period Section
        // When the inputs for the Orbital Period are changed, clear the Orbital Period output textbox.
        private void OPTab_OPInputs_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                OPTab_OutputOP_TextBox.Text = "0";
            }
        }

        // Body Mass ComboBox text replaced when you click an option in the dropdown.
        private void OPTab_InputBodyMass_ComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodymassbox = 1;
            BodyMassComboBoxTextReplacer();
        }

        // Clicking the Orbital Period calculate button.
        private void OPTab_OPCalc_CalculateButton_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(OPTab_InputSemMajAx_TextBox.Text) || double.Parse(OPTab_InputSemMajAx_TextBox.Text) == 0
                ||
                String.IsNullOrEmpty(OPTab_InputBodyMass_ComboBox.Text) || double.Parse(OPTab_InputBodyMass_ComboBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            double twopiinput = Math.PI * 2;
            double semmajaxinput = double.Parse(OPTab_InputSemMajAx_TextBox.Text);
            double gravconstinput = double.Parse(OPTab_InputGravConst_TextBox.Text);
            double bodymassinput = double.Parse(OPTab_InputBodyMass_ComboBox.Text);

            OPTab_OutputOP_TextBox.Text = ( twopiinput * Math.Sqrt(Math.Pow(semmajaxinput, 3) / (gravconstinput * bodymassinput)) ).ToString();
        }


        // When the inputs for the Apo/Peri (With OP) are changed, clear the ApoPeri output textbox.
        private void OPTab_ApoPeriInputs_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                OPTab_OutputApoPeri_TextBox.Text = "0";
            }
        }

        // Body Mass ComboBox text replaced when you click an option in the dropdown.
        private void OPTab_InputBodyMass_ComboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodymassbox = 2;
            BodyMassComboBoxTextReplacer();
        }

        // Body Radius ComboBox text replaced when you click an option in the dropdown.
        private void OPTab_InputBodyRadius_ComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodyradiusbox = 2;
            BodyRadiusComboBoxTextReplacer();
        }

        // Clicking the ApoPeri (With OP) calculate button.
        private void OPTab_ApoPeriCalc_CalculateButton_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(OPTab_InputBodyMass2_ComboBox.Text) || double.Parse(OPTab_InputBodyMass2_ComboBox.Text) == 0
                ||
                String.IsNullOrEmpty(OPTab_InputOP_TextBox.Text) || double.Parse(OPTab_InputOP_TextBox.Text) == 0
                ||
                String.IsNullOrEmpty(OPTab_InputBodyRadius_ComboBox.Text) || double.Parse(OPTab_InputBodyRadius_ComboBox.Text) == 0
                ||
                String.IsNullOrEmpty(OPTab_InputPeriApo_TextBox.Text) || double.Parse(OPTab_InputPeriApo_TextBox.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            double gravconstinput = double.Parse(OPTab_InputGravConst2_TextBox.Text);
            double bodymassinput = double.Parse(OPTab_InputBodyMass2_ComboBox.Text);

            double opinput = double.Parse(OPTab_InputOP_TextBox.Text);
            double opsquareinput = Math.Pow(opinput, 2);

            double pisquared = Math.Pow(Math.PI, 2);

            double bodyradiusinput = double.Parse(OPTab_InputBodyRadius_ComboBox.Text);
            double twobodyradiusinput = bodyradiusinput * 2;

            double periapoinput = double.Parse(OPTab_InputPeriApo_TextBox.Text);
            
            OPTab_OutputApoPeri_TextBox.Text = (Math.Pow(2 * gravconstinput * bodymassinput * opsquareinput / pisquared, 1.0 / 3.0) - twobodyradiusinput - periapoinput).ToString();                                    
        }
        #endregion


        #region Hohmann Transfer Section

        #region Text Replacement (+Setting Check for Output Change)
        private void HohTab_InputBodyMass_ComboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodymassbox = 3;
            BodyMassComboBoxTextReplacer();
        }

        private void HohTab_InputBodyRadius_ComboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodyradiusbox = 3;
            BodyRadiusComboBoxTextReplacer();
        }

        private void HohTab_InputBodyMass_ComboBox1_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output1stBurnDV_TextBox.Text = "0";
            }
        }
        
        private void HohTab_InputBodyRadius_ComboBox1_TextChanged(object sender, EventArgs e)
        {
            HohTab_InputBodyRadius_ComboBox2.Text = HohTab_InputBodyRadius_ComboBox1.Text;
            HohTab_InputBodyRadius_ComboBox3.Text = HohTab_InputBodyRadius_ComboBox1.Text;

            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output1stBurnDV_TextBox.Text = "0";
            }
        }

        private void HohTab_InputCurOrb_TextBox1_TextChanged(object sender, EventArgs e)
        {
            HohTab_InputCurOrb_TextBox2.Text = HohTab_InputCurOrb_TextBox1.Text;

            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output1stBurnDV_TextBox.Text = "0";
            }
        }

        private void HohTab_InputTarOrb_TextBox1_TextChanged(object sender, EventArgs e)
        {
            HohTab_InputTarOrb_TextBox2.Text = HohTab_InputTarOrb_TextBox1.Text;

            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output1stBurnDV_TextBox.Text = "0";
            }
        }


        private void HohTab_InputBodyMass_ComboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodymassbox = 4;
            BodyMassComboBoxTextReplacer();
        }

        private void HohTab_InputBodyRadius_ComboBox4_SelectedIndexChanged(object sender, EventArgs e)
        {
            bodyradiusbox = 4;
            BodyRadiusComboBoxTextReplacer();
        }

        private void HohTab_InputBodyMass_ComboBox2_TextChanged(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output2ndBurnDV_TextBox.Text = "0";
            }
        }

        private void HohTab_InputBodyRadius_ComboBox4_TextChanged(object sender, EventArgs e)
        {
            HohTab_InputBodyRadius_ComboBox5.Text = HohTab_InputBodyRadius_ComboBox4.Text;
            HohTab_InputBodyRadius_ComboBox6.Text = HohTab_InputBodyRadius_ComboBox4.Text;

            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output2ndBurnDV_TextBox.Text = "0";
            }
        }

        private void HohTab_InputCurOrb_TextBox3_TextChanged(object sender, EventArgs e)
        {
            HohTab_InputCurOrb_TextBox4.Text = HohTab_InputCurOrb_TextBox3.Text;

            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output2ndBurnDV_TextBox.Text = "0";
            }
        }

        private void HohTab_InputTarOrb_TextBox3_TextChanged(object sender, EventArgs e)
        {
            HohTab_InputTarOrb_TextBox4.Text = HohTab_InputTarOrb_TextBox3.Text;

            if (Properties.Settings.Default.SettingsCheckbox2 == true)
            {
                HohTab_Output2ndBurnDV_TextBox.Text = "0";
            }
        }
        #endregion

        private void HohTab_1stBurnCalc_CalculateButton_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(HohTab_InputGravConst_TextBox1.Text) || double.Parse(HohTab_InputGravConst_TextBox1.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputBodyMass_ComboBox1.Text) || double.Parse(HohTab_InputBodyMass_ComboBox1.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputCurOrb_TextBox1.Text) || double.Parse(HohTab_InputCurOrb_TextBox1.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputTarOrb_TextBox1.Text) || double.Parse(HohTab_InputTarOrb_TextBox1.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputBodyRadius_ComboBox1.Text) || double.Parse(HohTab_InputBodyRadius_ComboBox1.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            double gravconstinput = double.Parse(HohTab_InputGravConst_TextBox1.Text);
            double bodymassinput = double.Parse(HohTab_InputBodyMass_ComboBox1.Text);

            double muinput = gravconstinput * bodymassinput;

            double bodyradiusinput = double.Parse(HohTab_InputBodyRadius_ComboBox1.Text);
            double curorbitinput = double.Parse(HohTab_InputCurOrb_TextBox1.Text);
            double tarorbitinput = double.Parse(HohTab_InputTarOrb_TextBox1.Text);

            double radiiinput = curorbitinput + tarorbitinput + (2*bodyradiusinput);

            HohTab_Output1stBurnDV_TextBox.Text = (Math.Sqrt(muinput / (curorbitinput + bodyradiusinput)) * (Math.Sqrt(2 * (tarorbitinput + bodyradiusinput) / radiiinput) - 1)).ToString();

            if (Properties.Settings.Default.SettingsCheckbox1 == true)
            {
                HohTab_InputTotalDV_textBox1.Text = HohTab_Output1stBurnDV_TextBox.Text;
            }
            
        }

        private void HohTab_2ndBurnCalc_CalculateButton_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(HohTab_InputGravConst_TextBox2.Text) || double.Parse(HohTab_InputGravConst_TextBox2.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputBodyMass_ComboBox2.Text) || double.Parse(HohTab_InputBodyMass_ComboBox2.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputCurOrb_TextBox3.Text) || double.Parse(HohTab_InputCurOrb_TextBox3.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputTarOrb_TextBox3.Text) || double.Parse(HohTab_InputTarOrb_TextBox3.Text) == 0
                ||
                String.IsNullOrEmpty(HohTab_InputBodyRadius_ComboBox4.Text) || double.Parse(HohTab_InputBodyRadius_ComboBox4.Text) == 0)
            {
                InputErrorWarning();
                return;
            }

            double gravconstinput = double.Parse(HohTab_InputGravConst_TextBox2.Text);
            double bodymassinput = double.Parse(HohTab_InputBodyMass_ComboBox2.Text);

            double muinput = gravconstinput * bodymassinput;

            double bodyradiusinput = double.Parse(HohTab_InputBodyRadius_ComboBox4.Text);
            double curorbitinput = double.Parse(HohTab_InputCurOrb_TextBox3.Text);
            double tarorbitinput = double.Parse(HohTab_InputTarOrb_TextBox3.Text);

            double radiiinput = curorbitinput + tarorbitinput + (2*bodyradiusinput);

            HohTab_Output2ndBurnDV_TextBox.Text = (Math.Sqrt(muinput / (tarorbitinput + bodyradiusinput)) * (1 - Math.Sqrt(2 * (curorbitinput + bodyradiusinput) / radiiinput))).ToString();

            if (Properties.Settings.Default.SettingsCheckbox1 == true)
            {
                HohTab_InputTotalDV_textBox2.Text = HohTab_Output2ndBurnDV_TextBox.Text;
            }
        }

        private void HohTab_TotalDVCalc_CalculateButton_Click(object sender, EventArgs e)
        {
            double dvinput1 = double.Parse(HohTab_InputTotalDV_textBox1.Text);
            double dvinput2 = double.Parse(HohTab_InputTotalDV_textBox2.Text);

            HohTab_OutputTotalDV_textBox.Text = (dvinput1 + dvinput2).ToString();
        }

        #endregion


        #region Additional Forms
        private void KMAPSettings_pictureBox_Click(object sender, EventArgs e)
        {
            SettingsForm popup = new SettingsForm();
            popup.ShowDialog();
        }

        private void TWRMath_pictureBox_Click(object sender, EventArgs e)
        {
            TWRMathForm popup = new TWRMathForm();
            popup.ShowDialog();
        }

        private void IspMath_pictureBox_Click(object sender, EventArgs e)
        {
            IspMathForm popup = new IspMathForm();
            popup.ShowDialog();
        }
        
        private void DVMath_pictureBox_Click(object sender, EventArgs e)
        {
            DVMathForm popup = new DVMathForm();
            popup.ShowDialog();
        }

        private void SemMajAxMath_pictureBox_Click(object sender, EventArgs e)
        {
            SemMajAxForm popup = new SemMajAxForm();
            popup.ShowDialog();
        }

        private void OPMath_pictureBox_Click(object sender, EventArgs e)
        {
            OPMathForm popup = new OPMathForm();
            popup.ShowDialog();
        }

        private void HohMath_pictureBox_Click(object sender, EventArgs e)
        {
            HohForm popup = new HohForm();
            popup.ShowDialog();
        }
        #endregion        


        #region Credits Links
        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start("https://www.iconfinder.com/icons/21328/autopilot_function_math_icon");
        }

        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start("https://wiki.gnome.org/Home");
            
        }

        private void linkLabel3_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start("http://www.gnu.org/copyleft/gpl.html");
        }

        private void linkLabel4_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start("https://www.reddit.com/user/teo1995");
        }

        private void linkLabel5_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start("http://forum.kerbalspaceprogram.com/index.php?/profile/151688-hysterrics/");
        }
        #endregion


        #region Image Button Lighten-on-Hover S**t
        private void KMAPSettings_pictureBox_MouseEnter(object sender, EventArgs e)
        {
            KMAPSettings_pictureBox.Image = KMAP.Properties.Resources._64x64_Settings_Icon__Lightened_;
        }

        private void KMAPSettings_pictureBox_MouseLeave(object sender, EventArgs e)
        {
            KMAPSettings_pictureBox.Image = KMAP.Properties.Resources._64x64_Settings_Icon;
        }

        // Since you can only view one at a time, and this probably isn't going to kill your PC, I can just set all of them instead of tediously creating events for each button.
        private void KMAPMathButtons_MouseEnter(object sender, EventArgs e)
        {
            TWRMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16___Lightened_;
            IspMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16___Lightened_;
            DVMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16___Lightened_;
            SemMajAxMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16___Lightened_;
            OPMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16___Lightened_;
            HohMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16___Lightened_;
        }

        private void KMAPMathButtons_MouseLeave(object sender, EventArgs e)
        {
            TWRMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16_;
            IspMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16_;
            DVMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16_;
            SemMajAxMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16_;
            OPMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16_;
            HohMath_pictureBox.Image = KMAP.Properties.Resources._1477354693_stock_function_autopilot__16x16_;
        }
        #endregion
    }
}
